/*******************************************************************************
*                                                                              *
* Project       : VAnet                                                        *
* Filename      : VAnetPodule.h                                                *
* Version       : 0.01 (25-Jul-2002)                                           *
* Author        : David J Ruck                                                 *
* Description   : TCP Socket support on Virtual Acorn / Red Squirrel Emulator  *
* Information   : Windows DLL Header file                                      *
*                                                                              *
********************************************************************************
* Change Log:                                                                  *
*                                                                              *
* Ver   Date         Description of change                                     *
* ----  -----------  ---------------------                                     *
* 0.01  25-Jul-2002  Initial revision                                          *
*                                                                              *
*******************************************************************************/

#ifndef __VANet_h
#define __VANet_h

//#include "IocPodule.h"
//#include "TimerInterface.h"

//////////////////////////////////////////////////////////////////////
// Literals 

#define STRING_LEN		256
#define MAX_SOCKETS		(FD_SETSIZE < 256 ? FD_SETSIZE : 256)
#define FIOSLEEPTW		_IOW('f', 121, int)
#define SO_REUSEPORT	0x0200

// callback rate in hz
#define TIMER_RATE		100

// rom is accessed on word boundaries and spread into 0x2000 bytes
// ie half of the module workspace
#define ROM_PAGE_SHIFT			11u
#define ROM_PAGE_SIZE			(1u<<ROM_PAGE_SHIFT)
#define ROM_PAGE_MASK			(ROM_PAGE_SIZE-1)

#define PODULE_REGISTERS		0x2000      // Regsiter address
#define PODULE_REGSIZE			0x2000		// Size of registers

// Podule I/O registers offsets
#define PODULE_ROMPAGE			0x0000      // page register for the podule rom
#define PODULE_INTR				0x0004      // interrupt register
#define PODULE_COMMAND			0x0008      // trigger action with command number
#define PODULE_RETURN			0x000C      // ARM glags returned from action
#define PODULE_EVENT_CODE		0x0010      // Event code returned by IRQ
#define PODULE_EVENT_SOCKET		0x0014      // Event socket handle returned by IRQ
#define PODULE_EVENT_IP			0x0018      // Event socket handle returned by IRQ
#define PODULE_PARAMS			0x001C      // 8 parameter words
#define PODULE_BLOCK			0x003C      // paramter data block
#define PODULE_BLOCK_END		0x2000      // end of data block
#define PODULE_BLOCK_SIZE		(PODULE_BLOCK_END-PODULE_BLOCK)

#define PODULE_INTR_BIT			0           // IRQ bit number

// Return register values
#define RET_WAIT				0
#define RET_DONE				1
#define RET_ERROR				2

// Socket flags
#define SOCKFLAG_BLOCKING		0x01
#define SOCKFLAG_ASYNC			0x02			

// Internet SWI's
#define Socket_Creat            0x41200
#define Socket_Bind             0x41201
#define Socket_Listen           0x41202
#define Socket_Accept           0x41203
#define Socket_Connect          0x41204
#define Socket_Recv             0x41205
#define Socket_Recvfrom         0x41206
#define Socket_Recvmsg          0x41207
#define Socket_Send             0x41208
#define Socket_Sendto           0x41209
#define Socket_Sendmsg          0x4120A
#define Socket_Shutdown         0x4120B
#define Socket_Setsockopt       0x4120C
#define Socket_Getsockopt       0x4120D
#define Socket_Getpeername      0x4120E
#define Socket_Getsockname      0x4120F
#define Socket_Close            0x41210
#define Socket_Select           0x41211
#define Socket_Ioctl            0x41212
#define Socket_Read             0x41213
#define Socket_Write            0x41214
#define Socket_Stat             0x41215
#define Socket_Readv            0x41216
#define Socket_Writev           0x41217
#define Socket_Gettsize         0x41218
#define Socket_Sendtosm         0x41219
#define Socket_Sysctl           0x4121A
#define Socket_Accept_1         0x4121B
#define Socket_Recvfrom_1       0x4121C
#define Socket_Recvmsg_1        0x4121D
#define Socket_Sendmsg_1        0x4121E
#define Socket_Getpeername_1    0x4121F
#define Socket_Getsockname_1    0x41220
#define Socket_InternalLookup   0x41221
#define Socket_Version			0x41222

// Resolver SWI's
#define Resolver_GetHostByName  0x46000
#define Resolver_GetHost        0x46001
#define Resolver_GetCache       0x46002
#define Resolver_CacheControl   0x46003

#include <stdint.h>

#define Byte uint8_t
#define Word int32_t
//////////////////////////////////////////////////////////////////////
// CVAnetPodule class

class CVAnetPodule// : public CIocPodule
{
//	DECLARE_COMPONENT(CVAnetPodule);

	Byte*		mRomBase;		// base of rom image
	Word		mRomSize;		// size of rom image
	Word		mIntMask;		// interrupt mask

//	IEvent		mTimer;			// timer used to generate interrupts
//	IScheduler* mScheduler;		// interface to the scheduler
	Word		mTimerTicks;	// ticks between interrupts

	Word		mLastCommand;	// Last command issued
//	clock_t     mTimeout;		// Polled operation timeout

	// podule registers
	Word*		mpRomPage;		// rom page register
	Word*		mpIntStatus;	// interrupt status
	Word*		mpCommand;		// command register
	Word*		mpReturn;		// returned flags
	Word*		mParams;		// command parameters array
	Byte*		mpBlock;		// data block
	Byte		mRegisters[PODULE_REGSIZE];

	// windows socket specific data
	WSADATA		mWsaData;
	struct
	{
		SOCKET	s;				// socket handle
		Word	f;				// flags word
	}			mSockets[MAX_SOCKETS];
	fd_set		mAsyncSet;

	Word		mLastEventCode;
	Word		mLastEventSocket;
	Word		mLastEventIP;

public:
	CVAnetPodule();
	virtual ~CVAnetPodule();

	// CComponent interface
	virtual BOOL Init();
	virtual BOOL Cleanup();
	virtual BOOL Connect();
	virtual BOOL Disconnect();

	// IocPodule interface
	virtual Byte ReadByte(podule *p, Word address);
	virtual void WriteByte(podule *p, Word address, Byte b);
	virtual Word ReadWord(podule *p, Word address);
	virtual void WriteWord(podule *p, Word address, Word w);

	// timer callback handler
	int			 TimerEvent(podule *p);

protected:
	// methods
	void		 Trigger(podule *p, Word reg, bool write);
	void		 StartCommand(void);
	void		 ExecCommand(void);
	void		 FinishCommand(int result, int wsaerr);
	int			 ReturnHostent(int result, int wsaerr);
	void __cdecl Error(Word errnum, const char *message, ...);
	SOCKET		 AddSocket(SOCKET s);
	void         MakeFDSets(int ndesc, fd_set *fdsets);
	void         DecodeFDSets(int ndesc, fd_set *fdsets);
	void		 CheckSockAddr(struct sockaddr_in* saddr);

#ifdef SOCKET_TRACE
	void CVAnetPodule::TraceSelect(int result, int wsaerr);
#endif
};

#endif
