#include "midimax.h"
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include "podules-win.h"

extern __declspec(dllexport) int InitDll();
extern __declspec(dllexport) uint8_t  readb(podule *p, int easi, uint32_t addr);
extern __declspec(dllexport) uint16_t readw(podule *p, int easi, uint32_t addr);
//extern __declspec(dllexport) uint32_t readl(podule *p, int easi, uint32_t addr);
extern __declspec(dllexport) void writeb(podule *p, int easi, uint32_t addr, uint8_t val);
extern __declspec(dllexport) void writew(podule *p, int easi, uint32_t addr, uint16_t val);
//extern __declspec(dllexport) void writel(podule *p, int easi, uint32_t addr, uint32_t val);
extern __declspec(dllexport) int timercallback(podule *p);
extern __declspec(dllexport) void reset(podule *p);

FILE *midilogf;

unsigned char intstat,intena;

void midilog(const char *format, ...)
{
   char buf[1024];
return;
   if (!midilogf) midilogf=fopen("midilog.txt","wt");
   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   fputs(buf,midilogf);
   fflush(midilogf);
}

void error(const char *format, ...)
{
   char buf[1024];
return;
   if (!midilogf) midilogf=fopen("midilog.txt","wt");
   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   fputs("Error : ",midilogf);
   fputs(buf,midilogf);
   fflush(midilogf);
}

void fatal(const char *format, ...)
{
   char buf[1024];
return;
   if (!midilogf) midilogf=fopen("midilog.txt","wt");
   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   fputs("Fatal : ",midilogf);
   fputs(buf,midilogf);
   fflush(midilogf);
}

unsigned char midirom[32768];
int midipage;

uint8_t readb(podule *p, int easi, uint32_t addr)
{
        unsigned char temp;
        idecallback=&p->msectimer;
//        midilog("Read MIDIB %i %04X\n",easi,addr);
//        if (easi) return midirom[(addr&0xFFFF)>>2];
        switch (addr&0x3000)
        {
                case 0x0000: case 0x1000:
//                        midilog("ROM read addr %04X\n",((midipage*2048)+((addr&0x1FFF)>>2))&0x7FFF);
                return midirom[((midipage*2048)+((addr&0x1FFF)>>2))&0x7FFF];
                case 0x3000:
                switch (addr&0x1C)
                {
                        case 8:
                        temp=intstat;
                        intstat=0;
                        p->irq=0;
                        return temp;
                }
        }
        return 0xFF;
}

uint16_t readw(podule *p, int easi, uint32_t addr)
{
        idecallback=&p->msectimer;
//        midilog("Read MIDIW %i %04X\n",easi,addr);
        return readb(p,easi,addr);
}

void writeb(podule *p, int easi, uint32_t addr, uint8_t val)
{
        idecallback=&p->msectimer;
//        midilog("Write MIDIB %i %04X %02X\n",easi,addr,val);
        switch (addr&0x3000)
        {
                case 0x2000:
                midipage=val;
                return;
                case 0x3000: /*16550*/
                switch (addr&0x1C)
                {
                        case 0: /*Data!*/
                        midi_win32_raw_midi(val);
                        *idecallback=1;
                        intstat=0;
                        p->irq=0;
        if (intena&2)
        {
                intstat=1|2; /*Transmitter empty*/
                p->irq=1;
//                midilog("Interrupt!\n");
        }
                        return;
                        case 4: /*Interrupt enable*/
                        intena=val;
                        return;
                }
        }
}

void writew(podule *p, int easi, uint32_t addr, uint16_t val)
{
        idecallback=&p->msectimer;
//        midilog("Write MIDIW %i %04X %04X\n",easi,addr,val);
}

void reset(podule *p)
{
//        midilog("Reset podule\n");
//        resetide();
        p->msectimer=0;
}

void initmidi()
{
        FILE *f;
        char fn[512];
//        append_filename(fn,exname,"zidefs",sizeof(fn));
        f=fopen("romish","rb");
        if (!f)
        {
                midilog("Failed to open ROMISH!\n");
                return;
        }
        fread(midirom,32768,1,f);
        fclose(f);
//        addpodule(NULL,icswritew,icswriteb,NULL,icsreadw,icsreadb,NULL);
//        midilog("MIDIMAX Initialised!\n");
}

int InitDll()
{
        initmidi();
        midi_win32_init(0,0);
}

int timercallback(podule *p)
{
//        midilog("Timer callback!\n");
        idecallback=&p->msectimer;
//        midilog("%i\n",*idecallback);
        *idecallback=0;
        #if 0
        if (intena&2)
        {
                intstat=1|2; /*Transmitter empty*/
                p->irq=1;
//                midilog("Interrupt!\n");
        }
        #endif
        return *idecallback;
}

BOOL APIENTRY DllMain (HINSTANCE hInst     /* Library instance handle. */ ,
                       DWORD reason        /* Reason this function is being called. */ ,
                       LPVOID reserved     /* Not used. */ )
{
    switch (reason)
    {
      case DLL_PROCESS_ATTACH:
        break;

      case DLL_PROCESS_DETACH:
        break;

      case DLL_THREAD_ATTACH:
        break;

      case DLL_THREAD_DETACH:
        break;
    }

    /* Returns TRUE on success, FALSE on failure */
    return TRUE;
}
