/*RPCemu v0.6 by Tom Walker
  IDE emulation*/

void callbackide(void);

#define _LARGEFILE_SOURCE
#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>
#include <sys/types.h>
#include "ics.h"

int *idecallback;
int skip512[4];
int cdromenabled=1;
void atapicommand();
int timetolive;
int dumpedread=0;
struct
{
        unsigned char atastat[4];
        unsigned char error,status;
        int secount,sector,cylinder,head,drive,cylprecomp;
        unsigned char command;
        unsigned char fdisk;
        int pos;
        int packlen;
        int spt[4],hpc[4];
        int packetstatus;
        int cdpos,cdlen;
        unsigned char asc;
        int discchanged;
        int board;
} icside;

int ideboard;
int idereset=0;
unsigned short idebuffer[65536];
unsigned char *idebufferb;
FILE *hdfile[4]={NULL,NULL};
//FILE *cdrom=NULL;
void closeide0(void)
{
        fclose(hdfile[0]);
}

void closeide1(void)
{
        fclose(hdfile[1]);
}

void closeide2(void)
{
        fclose(hdfile[2]);
}

void closeide3(void)
{
        fclose(hdfile[3]);
}

void loadhd(int d, char *fn)
{
        if (!hdfile[d])
        {
                hdfile[d]=fopen(fn,"rb+");
                if (!hdfile[d])
                {
                        hdfile[d]=fopen64(fn,"rb+");
                        if (!hdfile[d])
                        {
                                hdfile[d]=fopen(fn,"wb");
                                if (!hdfile[d]) fatal("Cannot create file %s", fn);
                                putc(0,hdfile[d]);
                                fclose(hdfile[d]);
                                hdfile[d]=fopen64(fn,"rb+");
                                if (!hdfile[d]) fatal("Cannot open file %s", fn);
                        }
                }
                switch (d)
                {
                        case 0: atexit(closeide0); break;
                        case 1: atexit(closeide1); break;
                        case 2: atexit(closeide2); break;
                        case 3: atexit(closeide3); break;
                }
        }
        fseek(hdfile[d],0xFC1,SEEK_SET);
        icside.spt[d]=getc(hdfile[d]);
        icside.hpc[d]=getc(hdfile[d]);
        skip512[d]=1;
//        rpclog("First check - spt %i hpc %i\n",icside.spt[0],icside.hpc[0]);
        if (!icside.spt[d] || !icside.hpc[d])
        {
                fseek(hdfile[d],0xDC1,SEEK_SET);
                icside.spt[d]=getc(hdfile[d]);
                icside.hpc[d]=getc(hdfile[d]);
//                rpclog("Second check - spt %i hpc %i\n",icside.spt[0],icside.hpc[0]);
                skip512[d]=0;
                if (!icside.spt[d] || !icside.hpc[d])
                {
                        icside.spt[d]=63;
                        icside.hpc[d]=16;
                        skip512[d]=1;
//        rpclog("Final check - spt %i hpc %i\n",icside.spt[0],icside.hpc[0]);
                }
        }
}

void resetide(void)
{
        int c;
        idebufferb=(unsigned char *)idebuffer;
        if (hdfile[0]) fclose(hdfile[0]);
        if (hdfile[1]) fclose(hdfile[1]);
        if (hdfile[2]) fclose(hdfile[2]);
        if (hdfile[3]) fclose(hdfile[3]);
        icside.atastat[0]=0x40;
//        *idecallback=0;
        loadhd(0,"hd5.hdf");
        loadhd(1,"hd6.hdf");
        icside.board=0;
        icside.command=0;
        icside.pos=0;
}

void writeidew(uint16_t val)
{
//        rpclog("Write data %08X %04X %i %07X %08X\n",icside.pos,val,icside.packetstatus,PC,armregs[5]);
#ifdef _RPCEMU_BIG_ENDIAN
		val=(val>>8)|(val<<8);
#endif
        idebuffer[icside.pos>>1]=val;
//        if (icside.command==0xA0) rpclog("Write packet %i %02X %02X %08X %08X\n",icside.pos,idebufferb[icside.pos],idebufferb[icside.pos+1],idebuffer,idebufferb);
        icside.pos+=2;
        if (icside.packetstatus==4)
        {
                if (icside.pos>=(icside.packlen+2))
                {
                        icside.packetstatus=5;
                        *idecallback=1;
//                        rpclog("Packet over!\n");
                }
                return;
        }
        else if (icside.packetstatus==5) return;
        else if (icside.command==0xA0 && icside.pos>=0xC)
        {
                icside.pos=0;
                icside.atastat[icside.board]=0x80;
                icside.packetstatus=1;
                *idecallback=1;
//                rpclog("Packet now waiting!\n");
        }
        else if (icside.pos>=512)
        {
                icside.pos=0;
                icside.atastat[icside.board]=0x80;
                *idecallback=0;
                callbackide();
        }
}

void writeide(uint16_t addr, uint8_t val)
{
//        int c;
//        rpclog("Write IDE %08X %02X %08X %08X\n",addr,val,PC-8,armregs[12]);
        switch (addr)
        {
                case 0x1F0:
                idebufferb[icside.pos++]=val;
                if (icside.pos>=512)
                {
                        icside.pos=0;
                        icside.atastat[icside.board]=0x80;
                        *idecallback=1;
                }
                return;
                case 0x1F1:
                icside.cylprecomp=val;
                return;
                case 0x1F2:
                icside.secount=val;
                return;
                case 0x1F3:
                icside.sector=val;
                return;
                case 0x1F4:
                icside.cylinder=(icside.cylinder&0xFF00)|val;
                return;
                case 0x1F5:
                icside.cylinder=(icside.cylinder&0xFF)|(val<<8);
                return;
                case 0x1F6:
                icside.head=val&0xF;
                if (((val>>4)&1)!=icside.drive)
                {
                        *idecallback=0;
                        icside.atastat[icside.board]=0x40;
                        icside.error=0;
                        icside.secount=1;
                        icside.sector=1;
                        icside.head=0;
                        icside.cylinder=0;
                        icside.cylprecomp=0;
                        idereset=0;
                        icside.command=0;
                        icside.packetstatus=0;
                        icside.packlen=0;
                        icside.cdlen=icside.cdpos=icside.pos=0;
                        memset(idebuffer,0,512);
                }
                icside.drive=(val>>4)&1;
                        icside.pos=0;
                        icside.atastat[icside.board]=0x40;
                return;
                case 0x1F7: /*Command register*/
                icside.command=val;
                icside.board=ideboard;
//                rpclog("New IDE command - %02X %i %i %08X\n",icside.command,icside.drive,icside.board,PC-8);
                icside.error=0;
                switch (val)
                {
                        case 0x08: /*Device reset*/
                        icside.atastat[icside.board]=0x40;
                        *idecallback=1;
                        return;
                        case 0x10: /*Restore*/
                        case 0x70: /*Seek*/
                        icside.atastat[icside.board]=0x40;
                        *idecallback=1;
                        return;
                        case 0x20: /*Read sector*/
/*                        if (icside.secount>1)
                        {
                                error("Read %i sectors from sector %i cylinder %i head %i\n",icside.secount,icside.sector,icside.cylinder,icside.head);
                                exit(-1);
                        }*/
//                        rpclog("Read %i sectors from sector %i cylinder %i head %i\n",icside.secount,icside.sector,icside.cylinder,icside.head);
                        icside.atastat[icside.board]=0x80;
                        *idecallback=1;
                        return;
                        case 0x30: /*Write sector*/
/*                        if (icside.secount>1)
                        {
                                error("Write %i sectors to sector %i cylinder %i head %i\n",icside.secount,icside.sector,icside.cylinder,icside.head);
                                exit(-1);
                        }*/
//                        rpclog("Write %i sectors to sector %i cylinder %i head %i\n",icside.secount,icside.sector,icside.cylinder,icside.head);
                        icside.atastat[icside.board]=0x08;
                        icside.pos=0;
                        return;
                        case 0x40: /*Read verify*/
//                        rpclog("Read verify %i sectors from sector %i cylinder %i head %i\n",icside.secount,icside.sector,icside.cylinder,icside.head);
                        icside.atastat[icside.board]=0x80;
                        *idecallback=1;
                        return;
                        case 0x50:
//                        rpclog("Format track %i head %i\n",icside.cylinder,icside.head);
                        icside.atastat[icside.board]=0x08;
//                        *idecallback=200;
                        icside.pos=0;
                        return;
                        case 0x91: /*Set parameters*/
                        icside.atastat[icside.board]=0x80;
                        *idecallback=1;
                        return;
                        case 0xA1: /*Identify packet device*/
                        case 0xE3: /*Idle*/
  //                      case 0x08: /*???*/
                        icside.atastat[icside.board]=0x80;
                        *idecallback=1;
                        return;
                        case 0xEC: /*Identify device*/
                        icside.atastat[icside.board]=0x80;
                        *idecallback=1;
                        return;
                        case 0xA0: /*Packet (ATAPI command)*/
                        icside.packetstatus=0;
                        icside.atastat[icside.board]=0x80;
                        *idecallback=1;
                        icside.pos=0;
//                        output=1;
                        return;
                }
                error("Bad IDE command %02X\n",val);
//                dumpregs();
                exit(-1);
                return;
                case 0x3F6:
                if ((icside.fdisk&4) && !(val&4))
                {
                        *idecallback=1;
                        idereset=1;
                        icside.atastat[icside.board]=0x80;
//                        rpclog("IDE Reset\n");
                }
                icside.fdisk=val;
                return;
        }
        error("Bad IDE write %04X %02X\n",addr,val);
//        dumpregs();
        exit(-1);
}

uint8_t readide(uint16_t addr)
{
        uint8_t temp;
//        FILE *f;
//        int c;
//        if (output==1) rpclog("Read IDE %08X %08X %08X\n",addr,PC-8,armregs[9]);
        switch (addr)
        {
                case 0x1F0:
/*                if (icside.command==0xA1 && !icside.pos)
                {
                        output=1;
                        timetolive=20000;
                }*/
//                rpclog("Read data %08X ",icside.pos);
/*                if (!dumpedread)
                {
                        f=fopen("ram212.dmp","wb");
                        for (c=0x2127800;c<0x2127C00;c++)
                        {
                                putc(readmemb(c),f);
                        }
                        fclose(f);
                }*/
                temp=idebufferb[icside.pos++];
//                rpclog("%04X\n",temp);
                if (icside.pos>=512)
                {
                        icside.pos=0;
                        icside.atastat[icside.board]=0x40;
//                        rpclog("End of transfer\n");
                }
                return temp;
                case 0x1F1:
//                rpclog("Read IDEerror %02X %02X\n",icside.atastat,icside.error);
                return icside.error;
                case 0x1F2:
                return (uint8_t)icside.secount;
                case 0x1F3:
                return (uint8_t)icside.sector;
                case 0x1F4:
//                        rpclog("Read cylinder low %02X\n",icside.cylinder&0xFF);
                return (uint8_t)(icside.cylinder&0xFF);
                case 0x1F5:
//                        rpclog("Read cylinder high %02X\n",icside.cylinder>>8);
                return (uint8_t)(icside.cylinder>>8);
                case 0x1F6:
                return (uint8_t)(icside.head|(icside.drive<<4));
                case 0x1F7:
                icslog("Read ATAstat %02X %i\n",icside.atastat,icside.board);
                return icside.atastat[icside.board];
                case 0x3F6:
//                rpclog("Read ATAstat %02X\n",icside.atastat);
                return icside.atastat[icside.board];
        }
        error("Bad IDE read %04X\n",addr);
//        dumpregs();
        exit(-1);
}

uint16_t readidew(void)
{
        uint16_t temp;
//        if (icside.command==0xA0) rpclog("Read data2 %08X %04X %07X\n",icside.pos,idebuffer[(icside.pos>>1)],PC);
//        if (output) rpclog("Read data2 %08X %02X%02X %07X\n",icside.pos,idebuffer[(icside.pos>>1)+1],idebuffer[(icside.pos>>1)],PC);
        temp=idebuffer[icside.pos>>1];
	#ifdef _RPCEMU_BIG_ENDIAN
		temp=(temp>>8)|(temp<<8);
	#endif
        icside.pos+=2;
        if ((icside.pos>=512 && icside.command!=0xA0) || (icside.command==0xA0 && icside.pos>=icside.packlen))
        {
//                rpclog("Over! packlen %i %i\n",icside.packlen,icside.pos);
                icside.pos=0;
                        icside.atastat[icside.board]=0x40;
                        icside.packetstatus=0;
                        if (icside.command==0x20)
                        {
                                icside.secount--;
                                if (icside.secount)
                                {
                                        icside.atastat[icside.board]=0x08;
                                        icside.sector++;
                                        if (icside.sector==(icside.spt[icside.drive|icside.board]+1))
                                        {
                                                icside.sector=1;
                                                icside.head++;
                                                if (icside.head==(icside.hpc[icside.drive|icside.board]))
                                                {
                                                        icside.head=0;
                                                        icside.cylinder++;
                                                }
                                        }
                                        icside.atastat[icside.board]=0x80;
                                        *idecallback=0;
                                        callbackide();
                                }
                        }

        }
        return temp;
}

void callbackide(void)
{
        off64_t addr;
        int c;
        icslog("Callback - %i %02X %08X %i\n",idereset,icside.command,idecallback,icside.board);
        *idecallback=0;
        if (idereset)
        {
                icside.atastat[icside.board]=0x40;
                icside.error=0;
                icside.secount=1;
                icside.sector=1;
                icside.head=0;
                icside.cylinder=0;
                idereset=0;
//                rpclog("Reset callback\n");
                return;
        }
        switch (icside.command)
        {
                case 0x08: /*Device reset*/
                icside.atastat[icside.board]=0x40;
                icside.error=1; /*Device passed*/
                icside.secount=icside.sector=1;
                icside.cylinder=0;
                return;
                case 0x10: /*Restore*/
                case 0x70: /*Seek*/
//                rpclog("Restore callback\n");
                icside.atastat[icside.board]=0x40;
                return;
                case 0x20: /*Read sectors*/
                icslog("Read sector %i %i %i\n",icside.hpc[icside.drive],icside.spt[icside.drive],skip512[icside.drive]);
//                readflash=1;
                addr=(off64_t)((((((uint64_t)icside.cylinder*(uint64_t)icside.hpc[icside.drive|icside.board])+(uint64_t)icside.head)*(uint64_t)icside.spt[icside.drive|icside.board])+((uint64_t)icside.sector-1)+(uint64_t)skip512[icside.drive|icside.board])*(uint64_t)512);
                icslog("Read %i %i %i %08X %08X %08X\n",icside.cylinder,icside.head,icside.sector,addr);
                /*                if (icside.cylinder || icside.head)
                {
                        error("Read from other cylinder/head");
                        exit(-1);
                }*/
                fseeko64(hdfile[icside.drive|icside.board],addr,SEEK_SET);
                fread(idebuffer,512,1,hdfile[icside.drive|icside.board]);
                icside.pos=0;
                icside.atastat[icside.board]=0x08;
                icslog("Read sector callback %i %i %i offset %08X %i left %i %i\n",icside.sector,icside.cylinder,icside.head,addr,icside.secount,icside.spt,*idecallback);
                return;
                case 0x30: /*Write sector*/
//                readflash=2;
                addr=(off64_t)((((((uint64_t)icside.cylinder*(uint64_t)icside.hpc[icside.drive|icside.board])+(uint64_t)icside.head)*(uint64_t)icside.spt[icside.drive|icside.board])+((uint64_t)icside.sector-1)+(uint64_t)skip512[icside.drive|icside.board])*(uint64_t)512);
//                addr=((((icside.cylinder*icside.hpc[icside.drive])+icside.head)*icside.spt[icside.drive])+(icside.sector-1)+skip512[icside.drive])*512;
//                rpclog("Write sector callback %i %i %i offset %08X %i left %i\n",icside.sector,icside.cylinder,icside.head,addr,icside.secount,icside.spt);
                fseeko64(hdfile[icside.drive|icside.board],addr,SEEK_SET);
                fwrite(idebuffer,512,1,hdfile[icside.drive|icside.board]);
                icside.secount--;
                if (icside.secount)
                {
                        icside.atastat[icside.board]=0x08;
                        icside.pos=0;
                        icside.sector++;
                        if (icside.sector==(icside.spt[icside.drive|icside.board]+1))
                        {
                                icside.sector=1;
                                icside.head++;
                                if (icside.head==(icside.hpc[icside.drive|icside.board]))
                                {
                                        icside.head=0;
                                        icside.cylinder++;
                                }
                        }
                }
                else
                   icside.atastat[icside.board]=0x40;
                return;
                case 0x40: /*Read verify*/
                icside.pos=0;
                icside.atastat[icside.board]=0x40;
//                rpclog("Read verify callback %i %i %i offset %08X %i left\n",icside.sector,icside.cylinder,icside.head,addr,icside.secount);
                return;
                case 0x50: /*Format track*/
                addr=(off64_t)((((((uint64_t)icside.cylinder*(uint64_t)icside.hpc[icside.drive|icside.board])+(uint64_t)icside.head)*(uint64_t)icside.spt[icside.drive|icside.board])+((uint64_t)icside.sector-1)+(uint64_t)skip512[icside.drive|icside.board])*(uint64_t)512);
//                addr=((((icside.cylinder*icside.hpc[icside.drive])+icside.head)*icside.spt[icside.drive])+skip512[icside.drive])*512;
//                rpclog("Format cyl %i head %i offset %08X %08X %08X secount %i\n",icside.cylinder,icside.head,addr,addr>>32,addr,icside.secount);
                fseeko64(hdfile[icside.drive|icside.board],addr,SEEK_SET);
                memset(idebufferb,0,512);
                for (c=0;c<icside.secount;c++)
                {
                        fwrite(idebuffer,512,1,hdfile[icside.drive|icside.board]);
                }
                icside.atastat[icside.board]=0x40;
                return;
                case 0x91: /*Set parameters*/
                icside.spt[icside.drive|icside.board]=icside.secount;
                icside.hpc[icside.drive|icside.board]=icside.head+1;
                icside.atastat[icside.board]=0x40;
                return;
                case 0xA1:
                case 0xE3:
                icside.atastat[icside.board]=0x41;
                icside.error=4;
                return;
                case 0xEC:
                memset(idebuffer,0,512);
//                idebuffer[1]=101; /*Cylinders*/
                idebuffer[1]=65535; /*Cylinders*/
                idebuffer[3]=16;  /*Heads*/
                idebuffer[6]=63;  /*Sectors*/
                for (addr=10;addr<20;addr++)
                    idebuffer[addr]=0x2020;
                for (addr=23;addr<47;addr++)
                    idebuffer[addr]=0x2020;
                idebufferb[46^1]='v'; /*Firmware version*/
                idebufferb[47^1]='0';
                idebufferb[48^1]='.';
                idebufferb[49^1]='6';
                idebufferb[54^1]='R'; /*Drive model*/
                idebufferb[55^1]='P';
                idebufferb[56^1]='C';
                idebufferb[57^1]='e';
                idebufferb[58^1]='m';
                idebufferb[59^1]='u';
                idebufferb[60^1]='H';
                idebufferb[61^1]='D';
                idebuffer[50]=0x4000; /*Capabilities*/
                icside.pos=0;
                icside.atastat[icside.board]=0x08;
                return;
                case 0xA0: /*Packet*/
                return;
        }
}
