#include "ics.h"
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include "podules-win.h"

extern __declspec(dllexport) int InitDll();
extern __declspec(dllexport) uint8_t  readb(podule *p, int easi, uint32_t addr);
extern __declspec(dllexport) uint16_t readw(podule *p, int easi, uint32_t addr);
//extern __declspec(dllexport) uint32_t readl(podule *p, int easi, uint32_t addr);
extern __declspec(dllexport) void writeb(podule *p, int easi, uint32_t addr, uint8_t val);
extern __declspec(dllexport) void writew(podule *p, int easi, uint32_t addr, uint16_t val);
//extern __declspec(dllexport) void writel(podule *p, int easi, uint32_t addr, uint32_t val);
extern __declspec(dllexport) int timercallback(podule *p);
extern __declspec(dllexport) void reset(podule *p);

FILE *icslogf;

void icslog(const char *format, ...)
{
   char buf[1024];
return;
   if (!icslogf) icslogf=fopen("icslog.txt","wt");
   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   fputs(buf,icslogf);
   fflush(icslogf);
}

void error(const char *format, ...)
{
   char buf[1024];
//return;
   if (!icslogf) icslogf=fopen("icslog.txt","wt");
   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   fputs("Error : ",icslogf);
   fputs(buf,icslogf);
   fflush(icslogf);
}

void fatal(const char *format, ...)
{
   char buf[1024];
//return;
   if (!icslogf) icslogf=fopen("icslog.txt","wt");
   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   fputs("Fatal : ",icslogf);
   fputs(buf,icslogf);
   fflush(icslogf);
}

unsigned char icsrom[8192];
int icspage;

uint8_t readb(podule *p, int easi, uint32_t addr)
{
        int temp;
        idecallback=&p->msectimer;
        icslog("Read ICSB %04X\n",addr);
        switch (addr&0x3000)
        {
                case 0x0000: case 0x1000:
                temp=((addr&0x1FFC)|(icspage<<13))>>2;
                return icsrom[temp];
                case 0x3000:
//                ideboard=2;
                return readide(((addr>>2)&7)+0x1F0);
        }
}

uint16_t readw(podule *p, int easi, uint32_t addr)
{
        idecallback=&p->msectimer;
        if ((addr&0x3000)==0x3000)
        {
                icslog("Read IDEW\n");
  //              ideboard=2;
                return readidew();
        }
        return readb(p,easi,addr);
}

void writeb(podule *p, int easi, uint32_t addr, uint8_t val)
{
        idecallback=&p->msectimer;
        icslog("Write ICSB %04X %02X\n",addr,val);
        switch (addr&0x3000)
        {
                case 0x2000: icspage=val; return;
                case 0x3000:
//                ideboard=2;
                writeide(((addr>>2)&7)+0x1F0,val);
                return;
        }
}

void writew(podule *p, int easi, uint32_t addr, uint16_t val)
{
        idecallback=&p->msectimer;
        if ((addr&0x3000)==0x3000)
        {
                icslog("WRITEIDEW\n");
//                ideboard=2;
                writeidew(val);
                return;
        }
        writeb(p,easi,addr,val);
}

void reset(podule *p)
{
        icslog("Reset podule\n");
        resetide();
        p->msectimer=0;
}

void initics()
{
        FILE *f;
        char fn[512];
//        append_filename(fn,exname,"zidefs",sizeof(fn));
        f=fopen("zidefs","rb");
        if (!f)
        {
                icslog("Failed to open ZIDEFS!\n");
                return;
        }
        fread(icsrom,8192,1,f);
        fclose(f);
//        addpodule(NULL,icswritew,icswriteb,NULL,icsreadw,icsreadb,NULL);
        icslog("ICS Initialised!\n");
}

int InitDll()
{
        initics();
        resetide();
}

int timercallback(podule *p)
{
        icslog("Timer callback!\n");
        idecallback=&p->msectimer;
        callbackide();
        icslog("%i\n",*idecallback);
        return *idecallback;
}

BOOL APIENTRY DllMain (HINSTANCE hInst     /* Library instance handle. */ ,
                       DWORD reason        /* Reason this function is being called. */ ,
                       LPVOID reserved     /* Not used. */ )
{
    switch (reason)
    {
      case DLL_PROCESS_ATTACH:
        break;

      case DLL_PROCESS_DETACH:
        break;

      case DLL_THREAD_ATTACH:
        break;

      case DLL_THREAD_DETACH:
        break;
    }

    /* Returns TRUE on success, FALSE on failure */
    return TRUE;
}
