#include <stdio.h>
#include "sdlalleg.h"
#include "mem.h"
#include "memc.h"

int monomode=0;
int oldvidx=640,oldvidy=256,oldvdouble=0;
int vidx,vidy;
int xstart,xend;
int ystart,yend;
int cystart,cyend,cxstart;
int cys,cye,cx;
unsigned long vidcontrol;
PALETTE pal,pal256;
int palchange=0;
int vdouble=0;

void writevidc(unsigned long val)
{
        int c;
        if ((val>>24)<0x4C)
        {
//                printf("Write VIDC %08X ",val);
                c=val>>26;
//                printf("%i %03X\n",c,val&0xFFF);
                pal[c].r=(val&0xF)<<2;
                pal[c].g=((val>>4)&0xF)<<2;
                pal[c].b=((val>>8)&0xF)<<2;
                palchange=1;
        }
        if ((val>>24)==0xE0) { printf("Write VIDC control %08X\n",val); vidcontrol=val; }
        if ((val>>24)==0x8C) xstart=(val>>13)&0x7FE;
        if ((val>>24)==0x90) xend=(val>>13)&0x7FE;
        if ((val>>24)==0x98) cxstart=(val>>13)&0x7FF;
        if ((val>>24)==0xAC) ystart=(val>>14)&0x3FF;
        if ((val>>24)==0xB0) yend=(val>>14)&0x3FF;
        if ((val>>24)==0xB8) cystart=((val>>14)&0x3FF)+1;
        if ((val>>24)==0xBC) cyend=((val>>14)&0x3FF)+1;
        vidx=xend-xstart;
        vidy=yend-ystart;
        if (vidx<0) vidx=256;
        if (vidy<0) vidy=256;
        if (vidy<=256) vdouble=1;
        else           vdouble=0;
        cys=cystart-ystart;
        cye=cyend-ystart;
        if (cys<0) cys=0;
        if (cye<0) cye=0;
        if (cye>=vidy) cye=vidy;
        cx=cxstart-xstart;
        if (monomode)
        {
                vidx<<=2;
                cx<<=2;
        }
}

BITMAP *b;
void initvid()
{
        set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,256,0,0);
        b=create_bitmap(640,256);
}

void resizevid()
{
        destroy_bitmap(b);
        if (vdouble) set_gfx_mode(GFX_AUTODETECT_WINDOWED,vidx,vidy<<1,0,0);
        else         set_gfx_mode(GFX_AUTODETECT_WINDOWED,vidx,vidy,0,0);
        b=create_bitmap(vidx,vidy);
        oldvidx=vidx;
        oldvidy=vidy;
        oldvdouble=vdouble;
        printf("Resize vid! %i %i %08X\n",vidx,vidy,b);
        fflush(stdout);
}

int oldcys,oldcye;
int oldf11;
void drawvid()
{
        int x,y,addr=vinit<<2;
        unsigned char val;
        int c,d;
        int yl=-1,yh=-1;
        if (key[KEY_F11] && !oldf11)
        {
                monomode^=1;
                writevidc(vidcontrol);
        }
        oldf11=key[KEY_F11];
        if (!(vidcontrol&2)) vidx*=2;
        if (vidx!=oldvidx || vidy!=oldvidy || vdouble!=oldvdouble)
           resizevid();
        if (!(vidcontrol&2)) vidx/=2;
        if (palchange)
        {
                if (((vidcontrol>>2)&3)==3)
                {
                        for (c=0;c<256;c+=16)
                        {
                                for (d=0;d<16;d++)
                                {
                                        pal256[c+d].r=pal[d&15].r;
                                        pal256[c+d].g=pal[d&15].g;
                                        pal256[c+d].b=pal[d&15].b;
                                        if (c&0x10) pal256[c+d].r|=0x20; else pal256[c+d].r&=~0x20;
                                        if (c&0x20) pal256[c+d].g|=0x10; else pal256[c+d].g&=~0x10;
                                        if (c&0x40) pal256[c+d].g|=0x20; else pal256[c+d].g&=~0x20;
                                        if (c&0x80) pal256[c+d].b|=0x20; else pal256[c+d].b&=~0x20;
/*                                        pal256[c+d].r<<=2;
                                        pal256[c+d].g<<=2;
                                        pal256[c+d].b<<=2;*/
                                }
                        }
                        set_palette(pal256);
                }
                else
                   set_palette(pal);
                palchange=0;
                for (c=0;c<128;c++) pagedirty[c]=1;
        }
        for (y=0;y<vidy;y++)
        {
                if (monomode)
                {
                        for (x=0;x<vidx;x+=8)
                        {
                                val=ramb[addr++];
                                val^=0xFF;
                                b->line[y][x+7]=(val&0x80)?15:0;
                                b->line[y][x+6]=(val&0x40)?15:0;
                                b->line[y][x+5]=(val&0x20)?15:0;
                                b->line[y][x+4]=(val&0x10)?15:0;
                                b->line[y][x+3]=(val&0x08)?15:0;
                                b->line[y][x+2]=(val&0x04)?15:0;
                                b->line[y][x+1]=(val&0x02)?15:0;
                                b->line[y][x]=(val&0x01)?15:0;
                                        if (addr==((vend+4)<<2)) addr=vstart<<2;
                        }
                }
                else
                {
                        switch ((vidcontrol>>2)&3)
                        {
                                case 0: /*1bpp*/
                                if (pagedirty[addr>>12] || pagedirty[(addr>>12)+1] || (y>=oldcys && y<=oldcye))
                                {
                                        if (vidcontrol&2)
                                        {
                                                for (x=0;x<vidx;x+=8)
                                                {
                                                        val=ramb[addr++];
                                                        b->line[y][x+7]=(val&0x80)?15:0;
                                                        b->line[y][x+6]=(val&0x40)?15:0;
                                                        b->line[y][x+5]=(val&0x20)?15:0;
                                                        b->line[y][x+4]=(val&0x10)?15:0;
                                                        b->line[y][x+3]=(val&0x08)?15:0;
                                                        b->line[y][x+2]=(val&0x04)?15:0;
                                                        b->line[y][x+1]=(val&0x02)?15:0;
                                                        b->line[y][x]=(val&0x01)?15:0;
                                                        if (addr==((vend+4)<<2)) addr=vstart<<2;
                                                }
                                        }
                                        else
                                        {
                                                for (x=0;x<(vidx<<1);x+=16)
                                                {
                                                        val=ramb[addr++];
                                                        b->line[y][x+14]=b->line[y][x+15]=(val&0x80)?15:0;
                                                        b->line[y][x+12]=b->line[y][x+13]=(val&0x40)?15:0;
                                                        b->line[y][x+10]=b->line[y][x+11]=(val&0x20)?15:0;
                                                        b->line[y][x+8] =b->line[y][x+9] =(val&0x10)?15:0;
                                                        b->line[y][x+6] =b->line[y][x+7] =(val&0x08)?15:0;
                                                        b->line[y][x+4] =b->line[y][x+5] =(val&0x04)?15:0;
                                                        b->line[y][x+2] =b->line[y][x+3] =(val&0x02)?15:0;
                                                        b->line[y][x]   =b->line[y][x+1] =(val&0x01)?15:0;
                                                        if (addr==((vend+4)<<2)) addr=vstart<<2;
                                                }
                                        }
                                }
                                else
                                {
                                        for (x=0;x<vidx;x+=8)
                                        {
                                                addr++;
                                                if (addr==((vend+4)<<2)) addr=vstart<<2;
                                        }
                                }
                                break;
                                case 1: /*2bpp*/
                                if (pagedirty[addr>>12] || pagedirty[(addr>>12)+1] || (y>=oldcys && y<=oldcye))
                                {
                                        if (vidcontrol&2)
                                        {
                                                for (x=0;x<vidx;x+=4)
                                                {
                                                        val=ramb[addr++];
                                                        b->line[y][x+3]=(val>>6)&3;
                                                        b->line[y][x+2]=(val>>4)&3;
                                                        b->line[y][x+1]=(val>>2)&3;
                                                        b->line[y][x]=(val&0x03);
                                                        if (addr==((vend+4)<<2)) addr=vstart<<2;
                                                }
                                        }
                                        else
                                        {
                                                for (x=0;x<(vidx<<1);x+=8)
                                                {
                                                        val=ramb[addr++];
                                                        b->line[y][x+6]=b->line[y][x+7]=(val>>6)&3;
                                                        b->line[y][x+4]=b->line[y][x+5]=(val>>4)&3;
                                                        b->line[y][x+2]=b->line[y][x+3]=(val>>2)&3;
                                                        b->line[y][x]  =b->line[y][x+1]=(val&0x03);
                                                        if (addr==((vend+4)<<2)) addr=vstart<<2;
                                                }
                                        }
                                }
                                else
                                {
                                        for (x=0;x<vidx;x+=4)
                                        {
                                                addr++;
                                                if (addr==((vend+4)<<2)) addr=vstart<<2;
                                        }
                                }
                                break;
                                case 2: /*4bpp*/
                                if (pagedirty[addr>>12] || pagedirty[(addr>>12)+1] || (y>=oldcys && y<=oldcye))
                                {
                                        if (yl==-1) yl=y;
                                        yh=y;
                                        if (vidcontrol&2)
                                        {
                                                for (x=0;x<vidx;x+=2)
                                                {
                                                        val=ramb[addr++];
                                                        b->line[y][x+1]=(val>>4)&0xF;
                                                        b->line[y][x]=(val&0xF);
                                                        if (addr==((vend+4)<<2)) addr=vstart<<2;
                                                }
                                        }
                                        else
                                        {
                                                for (x=0;x<(vidx<<1);x+=4)
                                                {
                                                        val=ramb[addr++];
                                                        b->line[y][x+2]=b->line[y][x+3]=(val>>4)&0xF;
                                                        b->line[y][x]  =b->line[y][x+1]=(val&0xF);
                                                        if (addr==((vend+4)<<2)) addr=vstart<<2;
                                                }
                                        }
                                }
                                else
                                {
                                        for (x=0;x<vidx;x+=2)
                                        {
                                                addr++;
                                                if (addr==((vend+4)<<2)) addr=vstart<<2;
                                        }
                                }
                                break;
                                case 3: /*8bpp*/
                                if (pagedirty[addr>>12] || pagedirty[(addr>>12)+1] || (y>=oldcys && y<=oldcye))
                                {
                                        if (yl==-1) yl=y;
                                        yh=y;
                                        if (vidcontrol&2)
                                        {
                                                for (x=0;x<vidx;x++)
                                                {
                                                        val=ramb[addr++];
                                                        b->line[y][x]=val;
                                                        if (addr==((vend+4)<<2)) addr=vstart<<2;
                                                }
                                        }
                                        else
                                        {
                                                for (x=0;x<(vidx<<1);x+=2)
                                                {
                                                        val=ramb[addr++];
                                                        b->line[y][x]=b->line[y][x+1]=val;
                                                        if (addr==((vend+4)<<2)) addr=vstart<<2;
                                                }
                                        }
                                }
                                else
                                {
                                        for (x=0;x<vidx;x++)
                                        {
                                                addr++;
                                                if (addr==((vend+4)<<2)) addr=vstart<<2;
                                        }
                                }
                                break;
                        }
                }
        }
//        printf("CINIT %08X\n",cinit);
        if (cye!=cys)
        {
                if (yl>cys) yl=cys;
                if (yl==-1) yl=cys;
                if (yh<cye) yh=cye;
        }
        addr=cinit<<2;
        for (y=cys;y<cye;y++)
        {
                for (x=0;x<32;x+=4)
                {
                        val=ramb[addr++];
                        if (val&3 && ((x+cx)<vidx)) b->line[y][x+cx]=(val&3)|0x10;
                        if ((val>>2)&3 && ((x+cx+1)<vidx)) b->line[y][x+cx+1]=((val>>2)&3)|0x10;
                        if ((val>>4)&3 && ((x+cx+2)<vidx)) b->line[y][x+cx+2]=((val>>4)&3)|0x10;
                        if ((val>>6)&3 && ((x+cx+3)<vidx)) b->line[y][x+cx+3]=((val>>6)&3)|0x10;
                }
        }
        oldcys=cys-2;
        oldcye=cye+2;
//        printf("BLIT %08X %08X %08X %08X\n",b,screen,b->line[128],b->line[186]);
//blit(b,screen,0,0,0,0,vidx,vidy);
//        rectfill(b,cx,cys,cx+32,cye,1);
        if (yh!=-1 && yl!=-1)
        {
                if (vdouble)
                {
                        if (vidcontrol&2) blitv(b,screen,0,yl,0,yl,vidx,yh-yl);
                        else              blitv(b,screen,0,yl,0,yl,vidx<<1,yh-yl);
                }
                else
                {
                        if (vidcontrol&2) blit(b,screen,0,yl,0,yl,vidx,yh-yl);
                        else              blit(b,screen,0,yl,0,yl,vidx<<1,yh-yl);
                }
        }
        for (c=0;c<128;c++) pagedirty[c]=0;
        writememcache=writemembcache=0xFFFFFFFF;
}
