/*Header to help convert Allegro code for SDL*/
#include <SDL/SDL.h>
#include <stdint.h>

int key[512];

#define END_OF_MAIN()

typedef struct
{
        unsigned char r,g,b;
} RGB;

typedef RGB PALETTE[256];

typedef struct
{
        int y;
        unsigned char *line[0];
} BITMAP;

#define GFX_AUTODETECT_WINDOWED 0
BITMAP *screen;
BITMAP *create_bitmap(int x, int y);

int mouse_x,mouse_y,mouse_b;

#define MSEC_TO_TIMER(x) (x)

void timer1irq();
void timer2irq();
void onesec();
void vblankirq();

int quited;


#define KEY_A SDLK_a
#define KEY_B SDLK_b
#define KEY_C SDLK_c
#define KEY_D SDLK_d
#define KEY_E SDLK_e
#define KEY_F SDLK_f
#define KEY_G SDLK_g
#define KEY_H SDLK_h
#define KEY_I SDLK_i
#define KEY_J SDLK_j
#define KEY_K SDLK_k
#define KEY_L SDLK_l
#define KEY_M SDLK_m
#define KEY_N SDLK_n
#define KEY_O SDLK_o
#define KEY_P SDLK_p
#define KEY_Q SDLK_q
#define KEY_R SDLK_r
#define KEY_S SDLK_s
#define KEY_T SDLK_t
#define KEY_U SDLK_u
#define KEY_V SDLK_v
#define KEY_W SDLK_w
#define KEY_X SDLK_x
#define KEY_Y SDLK_y
#define KEY_Z SDLK_z

#define KEY_1 SDLK_1
#define KEY_2 SDLK_2
#define KEY_3 SDLK_3
#define KEY_4 SDLK_4
#define KEY_5 SDLK_5
#define KEY_6 SDLK_6
#define KEY_7 SDLK_7
#define KEY_8 SDLK_8
#define KEY_9 SDLK_9
#define KEY_0 SDLK_0

#define KEY_BACKSPACE SDLK_BACKSPACE
#define KEY_TAB SDLK_TAB
#define KEY_ENTER SDLK_RETURN
#define KEY_SPACE SDLK_SPACE

#define KEY_UP SDLK_UP
#define KEY_DOWN SDLK_DOWN
#define KEY_LEFT SDLK_LEFT
#define KEY_RIGHT SDLK_RIGHT

#define KEY_0_PAD SDLK_KP0
#define KEY_1_PAD SDLK_KP1
#define KEY_2_PAD SDLK_KP2
#define KEY_3_PAD SDLK_KP3
#define KEY_4_PAD SDLK_KP4
#define KEY_5_PAD SDLK_KP5
#define KEY_6_PAD SDLK_KP6
#define KEY_7_PAD SDLK_KP7
#define KEY_8_PAD SDLK_KP8
#define KEY_9_PAD SDLK_KP9

#define KEY_F1 SDLK_F1
#define KEY_F2 SDLK_F2
#define KEY_F3 SDLK_F3
#define KEY_F4 SDLK_F4
#define KEY_F5 SDLK_F5
#define KEY_F6 SDLK_F6
#define KEY_F7 SDLK_F7
#define KEY_F8 SDLK_F8
#define KEY_F9 SDLK_F9
#define KEY_F10 SDLK_F10
#define KEY_F11 SDLK_F11
#define KEY_F12 SDLK_F12

#define KEY_ESC SDLK_ESCAPE

#define KEY_TILDE SDLK_BACKQUOTE
#define KEY_MINUS SDLK_MINUS
#define KEY_EQUALS SDLK_EQUALS
#define KEY_OPENBRACE SDLK_LEFTBRACKET
#define KEY_CLOSEBRACE SDLK_RIGHTBRACKET
#define KEY_COLON SDLK_COLON
#define KEY_SEMICOLON SDLK_SEMICOLON
#define KEY_QUOTE SDLK_QUOTE
#define KEY_SLASH SDLK_SLASH
#define KEY_BACKSLASH SDLK_BACKSLASH
#define KEY_COMMA SDLK_COMMA
#define KEY_STOP SDLK_PERIOD
#define KEY_INSERT SDLK_INSERT
#define KEY_DEL SDLK_DELETE
#define KEY_HOME SDLK_HOME
#define KEY_END SDLK_END
#define KEY_PGUP SDLK_PAGEUP
#define KEY_PGDN SDLK_PAGEDOWN
#define KEY_SLASH_PAD SDLK_KP_DIVIDE
#define KEY_ASTERISK SDLK_KP_MULTIPLY
#define KEY_MINUS_PAD SDLK_KP_MINUS
#define KEY_PLUS_PAD SDLK_KP_PLUS

#define KEY_LSHIFT SDLK_LSHIFT
#define KEY_RSHIFT SDLK_RSHIFT
#define KEY_LCONTROL SDLK_LCTRL
#define KEY_RCONTROL SDLK_RCTRL
#define KEY_CAPSLOCK SDLK_CAPSLOCK
#define KEY_NUMLOCK SDLK_NUMLOCK
#define KEY_SCRLOCK SDLK_SCROLLOCK
#define KEY_ALT SDLK_LALT
#define KEY_ALTGR SDLK_RALT

#define KEY_BACKSLASH2 0 /*Don't think this one is in SDL*/
#define KEY_DEL_PAD SDLK_KP_PERIOD
#define KEY_ENTER_PAD SDLK_KP_ENTER
#define KEY_PAUSE SDLK_PAUSE
