#include <SDL/SDL.h>
#include "sdlalleg.h"

SDL_Surface *scr;

SDL_PixelFormat *fmt;

void allegro_init()
{
        printf("SDL ON!!\n");
        if ((SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_TIMER)==-1))
        {
                error("SDL failed to init!\n");
                exit(-1);
        }
        atexit(SDL_Quit);
}

void set_gfx_mode(int c, int x, int y, int vx, int vy)
{
        printf("SET GFX MODE %i,%i\n",x,y);
        scr=SDL_SetVideoMode(x, y, 16, SDL_SWSURFACE|SDL_ANYFORMAT);
        if (!scr)
        {
                error("SDL failed to init video!\n");
                exit(-1);
        }
        fmt=scr->format;
        printf("%i bpp\n",fmt->BitsPerPixel);
        screen=malloc(sizeof(BITMAP));
}

void install_keyboard()
{
}

void install_mouse()
{
}

SDL_TimerID timer1handle=NULL;
SDL_TimerID timer2handle=NULL;
SDL_TimerID onesechandle;
SDL_TimerID vblankhandle;
int timer1time,timer2time;

uint32_t SDLtimer1(uint32_t interval, void *param)
{
        timer1irq();
        return timer1time;
}
uint32_t SDLtimer2(uint32_t interval, void *param)
{
        timer2irq();
        return timer2time;
}
uint32_t SDLonesec(uint32_t interval, void *param)
{
//        printf("Onesec handle\n");
        onesec();
        return 1000;
}
uint32_t SDLvblank(uint32_t interval, void *param)
{
        vblankirq();
        return 20;
}

void install_int_ex(void *rout, int time)
{
//        printf("INSTALL INT!\n");
        if (rout==timer1irq)
        {
                if (timer1handle) SDL_RemoveTimer(timer1handle);
                timer1time=time;
                timer1handle=SDL_AddTimer(time,SDLtimer1,NULL);
        }
        if (rout==timer2irq)
        {
                if (timer2handle) SDL_RemoveTimer(timer2handle);
                timer2time=time;
                timer2handle=SDL_AddTimer(time,SDLtimer2,NULL);
        }
        if (rout==onesec) onesechandle=SDL_AddTimer(1000,SDLonesec,NULL);
        if (rout==vblankirq) vblankhandle=SDL_AddTimer(1000,SDLvblank,NULL);
}

void install_timer()
{
}

BITMAP *create_bitmap(int x, int y)
{
        int c;
        BITMAP *b=malloc(sizeof(BITMAP)+(y*(sizeof(unsigned char *))));
        b->y=y;
        for (c=0;c<y;c++)
        {
                b->line[c]=malloc(x);
        }
        printf("Create bitmap with %i lines of %i bytes\n",y,x);
        return b;
}

void destroy_bitmap(BITMAP *b)
{
        int c;
        if (!b) return;
        for (c=0;c<b->y;c++)
        {
                if (b->line[c]) free(b->line[c]);
        }
        free(b);
}

unsigned long transpalette[256];

void set_palette(PALETTE pal)
{
        int c;
        for (c=0;c<256;c++)
        {
                transpalette[c]=SDL_MapRGB(fmt,pal[c].r<<2,pal[c].g<<2,pal[c].b<<2);
        }
}

void blit(BITMAP *src, BITMAP *dest, int x1, int y1, int x2, int y2, int xs, int ys)
{
        int y,x;
        int bpp=16;
        uint8_t *scrp;
        if (dest==screen) /*Blitting to screen*/
        {
                SDL_LockSurface(scr);
                for (y=0;y<ys;y++)
                {
                        scrp=(uint8_t *)scr->pixels + ((y+y2) * scr->pitch) + (x2 * bpp);
                        for (x=0;x<xs;x++)
                        {
                                ((uint16_t *)scrp)[x]=transpalette[src->line[y+y1][x+x1]&255];
                        }
                }
                SDL_UnlockSurface(scr);
                SDL_UpdateRect(scr,x2,y2,xs,ys);
        }
}
void blitv(BITMAP *src, BITMAP *dest, int x1, int y1, int x2, int y2, int xs, int ys)
{
        int y,x;
        int bpp=16;
        uint8_t *scrp;
        if (dest==screen) /*Blitting to screen*/
        {
                SDL_LockSurface(scr);
                ys*=2;
                y2*=2;
                for (y=0;y<ys;y++)
                {
                        scrp=(uint8_t *)scr->pixels + ((y+y2) * scr->pitch) + (x2 * bpp);
                        for (x=0;x<xs;x++)
                        {
                                ((uint16_t *)scrp)[x]=transpalette[src->line[(y>>1)+y1][x+x1]&255];
                        }
                }
                SDL_UnlockSurface(scr);
                SDL_UpdateRect(scr,x2,y2,xs,ys);
        }
}

int quited=0;
void poll_sdl()
{
        SDL_Event event;
        unsigned char *k;
        int c;
        while(SDL_PollEvent(&event))
        {
                switch(event.type)
                {
                        case SDL_MOUSEMOTION:
                        mouse_x=event.motion.x;
                        mouse_y=event.motion.y;
                        mouse_b=0;
                        if (event.motion.state&SDL_BUTTON(1)) mouse_b|=1;
                        if (event.motion.state&SDL_BUTTON(2)) mouse_b|=4;
                        if (event.motion.state&SDL_BUTTON(4)) mouse_b|=2;
                        break;
                        case SDL_MOUSEBUTTONDOWN:
                        case SDL_MOUSEBUTTONUP:
                        mouse_b=0;
                        if (event.button.state&SDL_BUTTON(1)) mouse_b|=1;
                        if (event.button.state&SDL_BUTTON(2)) mouse_b|=4;
                        if (event.button.state&SDL_BUTTON(4)) mouse_b|=2;
                        break;
                        case SDL_QUIT:
                        quited=1;
                        break;
                        case SDL_KEYDOWN:
                        key[event.key.keysym.sym]=1;
                        rpclog("KEY DOWN %02X %i\n",event.key.keysym.sym,event.key.keysym.sym);
                        break;
                        case SDL_KEYUP:
                        key[event.key.keysym.sym]=0;
                        break;
                }
        }
        mouse_b=0;
        if(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON_LMASK) mouse_b|=1;
        if(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON_RMASK) mouse_b|=2;
        if(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON_MMASK) mouse_b|=4;
//        k=SDL_GetKeyState(NULL);
//        for (c=0;c<512;c++) key[c]=k[c];
}
