/*RPCemu v0.6 by Tom Walker
  ROM loader*/
#include <io.h>
#include <stdint.h>
#include "sdlalleg.h"
#include <stdio.h>
#include "mem.h"

char romfns[17][256];

unsigned char *get_extension(unsigned char *s)
{
        int c=0;
        int d=0;
        while (s[c])
        {
                if (s[c]=='.') d=c;
                c++;
        }
        d++;
        return &s[d];
}

int loadroms()
{
        FILE *f;
        int finished=0;
        int file=0;
        int c,d,e;
        int len,pos=0;
        long handle;
        struct _finddata_t ff;
		uint32_t temp;
//        char s[256];
        char olddir[512],fn[512];
        char *ext;
        printf("In loadroms!\n");
        chdir("roms");
        handle=_findfirst("*.*",&ff);
        printf("Findfirst - %i\n",handle);
        if (handle==-1)
        {
                chdir(olddir);
                return -1;
        }
        finished=0;
        while (!finished && file<16)
        {
                ext=get_extension(ff.name);
				printf("Found rom %s %s\n",ff.name,ext);
                if (stricmp(ext,"txt"))
                {
                        strcpy(romfns[file],ff.name);
                        file++;
                }
                finished = _findnext(handle,&ff);
        }
        _findclose(handle);
        if (file==0)
        {
                chdir(olddir);
                return -1;
        }
//printf("Loading file...\n");
        for (c=0;c<file;c++)
        {
                for (d=0;d<file;d++)
                {
                        if (c>d)
                        {
                                e=0;
                                while (romfns[c][e]==romfns[d][e] && romfns[c][e])
                                      e++;
                                if (romfns[c][e]<romfns[d][e])
                                {
                                        memcpy(romfns[16],romfns[c],256);
                                        memcpy(romfns[c],romfns[d],256);
                                        memcpy(romfns[d],romfns[16],256);
                                }
                        }
                }
        }
//printf("Really loading files...\n");
        for (c=0;c<file;c++)
        {
                f=fopen(romfns[c],"rb");
		printf("Loading %s\n",romfns[c]);
                if (f)
                {
                        fseek(f,-1,SEEK_END);
                        len=ftell(f)+1;
                        printf("Reading %i bytes\n",len);
                        fseek(f,0,SEEK_SET);
                        fread(&romb[pos],len,1,f);
                        fclose(f);
                        pos+=len;
                }
        }
        chdir("..");
#ifdef _RPCEMU_BIG_ENDIAN /*Byte swap*/
#error It's defined...
//printf("Byte swapping...\n");
		for (c=0;c<0x800000;c+=4)
		{
				temp=rom[c>>2];
				temp=((temp&0xFF000000)>>24)|((temp&0x00FF0000)>>8)|((temp&0x0000FF00)<<8)|((temp&0x000000FF)<<24);
//				temp=((temp>>24)&0xFF)|((temp>>8)&0xFF00)|((temp<<8)&0xFF0000)|((temp<<24)|0xFF000000);
				rom[c>>2]=temp;
		}
#endif
        return 0;
}
