#include <stdint.h>
#include "arm.h"
#include "memc.h"
#include "mem.h"
#include "ioc.h"

unsigned long inscount;
void initmemc()
{
        memset(logmap,0xFF,1024*4);
        memset(cam,0xFF,512*4);
}

int memtimes=0;

#define getdmaaddr(addr) (((addr>>2)&0x7FFF)<<2)

void writememc(unsigned long addr)
{
        int physical,logical,c;
        if (addr>=0x3800000) /*CAM mapping*/
        {
                if (addr==0x3800000)
                {
                        memtimes++;
//                        if (memtimes==3)
//                           output=1;
                }
                physical=((addr>>3)&0xf) | ((addr&1)<<4) | ((addr&2)<<5) | ((addr&4)<<3);
                if (addr&0x80) physical|=0x80;
                if (addr&0x1000) physical|=0x100;
                for (c=0;c<1024;c++)
                {
                        if (logmap[c]==physical<<15)
                        {
                                logmap[c]=0xFFFFFFFF;
//                                printf("Erased %i %i\n",c,physical);
                        }
                }
                logical=(addr>>15)&0xFF;
                logical|=(addr>>2)&0x300;
                if (physical==readmemcache) readmemcache=0xFFFFFFFF;
                logmap[logical]=physical<<15;
                cam[physical]=logical;
                resetcodeblocks();
//                printf("Mapped %08X to %08X  %02X %03X %08X %i %i %08X\n",physical<<15,logical<<15,physical,logical,addr,memtimes,inscount,fiqregs[12]);
//                if (output)                rpclog("Mapped %08X to %08X  %02X %03X %08X %i %i\n",physical<<15,logical<<15,physical,logical,addr,memtimes,inscount);
        }
        else
        {
                switch ((addr>>17)&7)
                {
                        case 0: vinit=getdmaaddr(addr); /*rpclog("Vinit write %08X %07X\n",vinit,PC);*/ return;
                        case 1: vstart=getdmaaddr(addr); /*rpclog("Vstart write %08X %07X\n",vstart,PC);*/return;
                        case 2: vend=getdmaaddr(addr); /*rpclog("Vend write %08X %07X\n",vend,PC);*/return;
                        case 3: cinit=getdmaaddr(addr); /*printf("CINIT=%05X\n",cinit<<2);*/ return;
                        case 4: ioc.statb&=~2; updateiocirqs(); return;
                        case 6: ioc.statb|=2; updateiocirqs(); return;
                        case 7:
                        printf("MEMC control %08X\n",addr);
                        break;
                }
                if (((addr>>17)&7)<=2) /*Force video update if addresses changed*/
                {
                        for (c=0;c<128;c++) pagedirty[c]=1;
                }
        }
}
