#include <stdint.h>
#include "arm.h"
#include "mem.h"
#include "memc.h"

extern unsigned char codeblockpresent[0x10000];

unsigned char *extroms;
unsigned long *extroml;
void initmem()
{
        rom=malloc(8192*1024);
        ram=malloc(16384*1024);
        romb=(unsigned char *)rom;
        ramb=(unsigned char *)ram;
        memset(ram,0,16384*1024);
        readmemcache=readmembcache=0xFFFFFFFF;
        writememcache=writemembcache=0xFFFFFFFF;
        extroms=malloc(512*1024);
        extnrom_load(512*1024, 16, extroms);
        extroml=(uint32_t *)extroms;
}

void arcabort(unsigned long addr)
{
        rpclog("Page not present! %08X\n",addr);
        dumpregs();
        exit(-1);
}

unsigned long *getpccache(unsigned long addr)
{
        unsigned long addr2=addr;
        if (addr<0x2000000) /*RAM (logical map*/
        {
                if (logmap[(addr>>15)&1023]&1) arcabort(addr);
                addr=logmap[(addr>>15)&1023]+(addr&0x7FFF);
                return &ram[((addr&0xFFFFFF)-addr2)>>2];
        }
        switch (addr&0x3F00000)
        {
                case 0x2000000: case 0x2100000: case 0x2200000: case 0x2300000: /*RAM (physical map*/
                case 0x2400000: case 0x2500000: case 0x2600000: case 0x2700000:
                case 0x2800000: case 0x2900000: case 0x2A00000: case 0x2B00000:
                case 0x2C00000: case 0x2D00000: case 0x2E00000: case 0x2F00000:
                return &ram[((addr&0xFFFFFF)-addr)>>2];
                case 0x3400000: case 0x3500000: case 0x3600000: case 0x3700000:
                return &extroml[((addr&0x7FFFF)-addr)>>2];
                case 0x3800000: case 0x3900000: case 0x3A00000: case 0x3B00000: /*ROM*/
                case 0x3C00000: case 0x3D00000: case 0x3E00000: case 0x3F00000:
                return &rom[((addr&0x1FFFFF)-addr)>>2];
        }
        rpclog("Bad getpccache %07X\n",addr);
        dumpregs();
        exit(-1);
}

unsigned long readmemfl(unsigned long addr)
{
        unsigned long addr2=addr;
        if (addr<0x2000000) /*RAM (logical map*/
        {
                if (logmap[(addr>>15)&1023]&1)
                {
                        armirq|=0x40;
                        return;
                }
//                printf("Read %08X ",addr);
                addr=logmap[(addr>>15)&1023]+(addr&0x7FFF);
                readmemcache=addr2>>15;
                readmemcache2=&ram[((addr&0xFFFFFF)-addr2)>>2];
//                printf("%08X\n",addr);
                return ram[(addr&0xFFFFFF)>>2];
        }
        switch (addr&0x3F00000)
        {
                case 0x2000000: case 0x2100000: case 0x2200000: case 0x2300000: /*RAM (physical map*/
                case 0x2400000: case 0x2500000: case 0x2600000: case 0x2700000:
                case 0x2800000: case 0x2900000: case 0x2A00000: case 0x2B00000:
                case 0x2C00000: case 0x2D00000: case 0x2E00000: case 0x2F00000:
//                readmemcache=addr>>15;
//                readmemcache2=&ram[((addr&0xFFFFFF)-addr2)>>2];
                return ram[(addr&0xFFFFFF)>>2];
                case 0x3000000:
                if ((addr&0xFFF)==0x7C0) return readidew();
                case 0x3100000: case 0x3200000: case 0x3300000: /*IOC*/
                return readioc(addr);
                case 0x3400000: case 0x3500000: case 0x3600000: case 0x3700000: /*Extension ROMs*/
                return extroml[(addr&0x7FFFF)>>2];
                case 0x3800000: case 0x3900000: case 0x3A00000: case 0x3B00000: /*ROM*/
                case 0x3C00000: case 0x3D00000: case 0x3E00000: case 0x3F00000:
                readmemcache=addr>>15;
                readmemcache2=&rom[((addr&0x1FFFFF)-addr2)>>2];
                return rom[(addr&0x1FFFFF)>>2];
        }
        rpclog("Bad readl %08X %07X\n",addr,PC);
        dumpregs();
        exit(-1);
}

unsigned char readmemfb(unsigned long addr)
{
        unsigned long addr2=addr;
        if (addr<0x2000000) /*RAM (logical map*/
        {
                if (logmap[(addr>>15)&1023]&1)
                {
                        armirq|=0x40;
                        return 0xff;
                }
                addr=logmap[(addr>>15)&1023]+(addr&0x7FFF);
                readmembcache=addr2>>15;
                readmembcache2=&ramb[(addr&0xFFFFFF)-addr2];
                return ramb[addr&0xFFFFFF];
        }
        switch (addr&0x3F00000)
        {
                case 0x2000000: case 0x2100000: case 0x2200000: case 0x2300000: /*RAM (physical map*/
                case 0x2400000: case 0x2500000: case 0x2600000: case 0x2700000:
                case 0x2800000: case 0x2900000: case 0x2A00000: case 0x2B00000:
                case 0x2C00000: case 0x2D00000: case 0x2E00000: case 0x2F00000:
                readmembcache=addr2>>15;
                readmembcache2=&ramb[(addr&0xFFFFFF)-addr2];
                return ramb[addr&0xFFFFFF];
                case 0x3000000: case 0x3100000: case 0x3200000: case 0x3300000: /*IOC*/
                return readioc(addr);
                case 0x3400000: case 0x3500000: case 0x3600000: case 0x3700000:
                return extroms[addr&0x7FFFF];
                case 0x3800000: case 0x3900000: case 0x3A00000: case 0x3B00000: /*ROM*/
                case 0x3C00000: case 0x3D00000: case 0x3E00000: case 0x3F00000:
                readmembcache=addr2>>15;
                readmembcache2=&romb[(addr&0x1FFFFF)-addr2];
                return romb[addr&0x1FFFFF];
        }
        rpclog("Bad readb %08X %07X\n",addr,PC);
        dumpregs();
        exit(-1);
}

void writememfl(unsigned long addr, unsigned long val)
{
        unsigned long addr2=addr;
//        if (val==959) printf("writing 480 to %08X\n",addr);
        if (addr<0x2000000) /*RAM (logical map*/
        {
                if (logmap[(addr>>15)&1023]&1)
                {
                        armirq|=0x40;
                        return;
                }
                if (codeblockpresent[(addr>>12)&0x7FF] && ((PC)&~0xFFF)!=(addr&~0xFFF)) cacheclearpage(addr>>12);
                addr=logmap[(addr>>15)&1023]+(addr&0x7FFF);
                pagedirty[addr>>12]=1;
                writememcache=addr2>>12;
                writememcache2=&ram[((addr&0xFFFFFF)-addr2)>>2];
                ram[(addr&0xFFFFFF)>>2]=val;
                return;
        }
        switch (addr&0x3F00000)
        {
                case 0x2000000: case 0x2100000: case 0x2200000: case 0x2300000: /*RAM (physical map*/
                case 0x2400000: case 0x2500000: case 0x2600000: case 0x2700000:
                case 0x2800000: case 0x2900000: case 0x2A00000: case 0x2B00000:
                case 0x2C00000: case 0x2D00000: case 0x2E00000: case 0x2F00000:
                writememcache=addr2>>12;
                writememcache2=&ram[((addr&0xFFFFFF)-addr2)>>2];
                ram[(addr&0xFFFFFF)>>2]=val;
                return;
                case 0x3000000:
                if ((addr&0xFFF)==0x7C0)
                {
                        writeidew(val>>16);
                        return;
                }
                case 0x3100000: case 0x3200000: case 0x3300000: /*IOC*/
                writeioc(addr,val>>16);
                return;
                case 0x3400000: /*VIDC*/
                writevidc(val);
                return;
                case 0x3600000: case 0x3700000: /*MEMC*/
                case 0x3800000: case 0x3900000: case 0x3A00000: case 0x3B00000: /*CAM*/
                case 0x3C00000: case 0x3D00000: case 0x3E00000: case 0x3F00000:
                writememc(addr);
                return;
        }
        rpclog("Bad writel %08X %08X %07X\n",addr,val,PC);
        dumpregs();
        exit(-1);
}

void writememfb(unsigned long addr, unsigned char val)
{
        unsigned long addr2=addr;
        if (addr<0x2000000) /*RAM (logical map*/
        {
                if (logmap[(addr>>15)&1023]&1)
                {
                        armirq|=0x40;
                        return;
                }
                if (codeblockpresent[(addr>>12)&0x7FF] && ((PC)&~0xFFF)!=(addr&~0xFFF)) cacheclearpage(addr>>12);
                addr=logmap[(addr>>15)&1023]+(addr&0x7FFF);
                pagedirty[addr>>12]=1;
                writemembcache=addr2>>12;
                writemembcache2=&ramb[(addr&0xFFFFFF)-addr2];
                ramb[addr&0xFFFFFF]=val;
                return;
        }
        switch (addr&0x3F00000)
        {
                case 0x2000000: case 0x2100000: case 0x2200000: case 0x2300000: /*RAM (physical map*/
                case 0x2400000: case 0x2500000: case 0x2600000: case 0x2700000:
                case 0x2800000: case 0x2900000: case 0x2A00000: case 0x2B00000:
                case 0x2C00000: case 0x2D00000: case 0x2E00000: case 0x2F00000:
                writemembcache=addr2>>12;
                writemembcache2=&ramb[(addr&0xFFFFFF)-addr2];
                ramb[addr&0xFFFFFF]=val;
                return;
                case 0x3000000: case 0x3100000: case 0x3200000: case 0x3300000: /*IOC*/
                writeioc(addr,val);
                return;
        }
        rpclog("Bad writeb %08X %02X %07X\n",addr,val,PC);
        dumpregs();
        exit(-1);
}
