#include "sdlalleg.h"
#include "arm.h"

int timetolive;

int i2cclock,i2cdata;
unsigned char iockey,iockey2,tempkey;
int keydelay,keydelay2,keyway;
int drawit=0;
struct
{
        unsigned char stata,statb,statf;
        unsigned char maska,maskb,maskf;
        unsigned short t1l,t2l,t3l,t4l;
        unsigned short t1c,t2c,t3c,t4c;
        unsigned short t1r,t2r,t3r,t4r;
} ioc;

void dumpiocregs()
{
        printf("IOC registers:\n");
        printf("IRQA %02X IRQB %02X FIQ %02X\n",ioc.stata,ioc.statb,ioc.statf);
        printf("MSKA %02X MSKB %02X MSF %02X\n",ioc.maska,ioc.maskb,ioc.maskf);
}

void updateiocirqs()
{
        int temp=(ioc.stata&ioc.maska&0x7F)|(ioc.statb&ioc.maskb&0xFF);
        if (temp) armirq|=1;
        else      armirq&=~1;
        if (ioc.statf&ioc.maskf) armirq|=2;
        else                     armirq&=~2;
}

void timer1irq()
{
        ioc.stata|=0x20;
//        printf("Timer 1!!\n");
        updateiocirqs();
}
void timer2irq()
{
        ioc.stata|=0x40;
        updateiocirqs();
}

int vblankcount=0;
void vblankirq()
{
        drawit=1;
        ioc.stata|=8;
        ioc.statb|=2;
        updateiocirqs();
        vblankcount=20;
}

void resetioc()
{
        ioc.stata=0x10;
        ioc.statb=ioc.statf=0;
        install_timer();
        ioc.statb|=0x40;
        install_int_ex(vblankirq,MSEC_TO_TIMER(20));
}

void settimer1()
{
        int temp=(ioc.t1l+1)/2000;
        if (!temp) temp=1;
//        printf("Timer 1 now %04X %i\n",ioc.t1l,temp);
        install_int_ex(timer1irq,MSEC_TO_TIMER(temp));
}
void settimer2()
{
        int temp=(ioc.t2l+1)/2000;
        if (!temp) temp=1;
//        printf("Timer 2 now %04X %i\n",ioc.t2l,temp);
        install_int_ex(timer2irq,MSEC_TO_TIMER(temp));
}

unsigned char readioc(unsigned long addr)
{
        int bank=(addr>>16)&7;
        switch (bank)
        {
                case 0: /*Internal registers*/
                switch (addr&0x7C)
                {
                        case 0x00: return ((i2cclock)?2:0)|((i2cdata)?1:0)|4|((vblankcount)?0x80:0); /*Control register*/
                        case 0x04: ioc.statb&=~0x80; updateiocirqs(); return iockey; /*Keyboard*/
                        case 0x10: return ioc.stata; /*IRQ status A*/
                        case 0x14: return ioc.stata&ioc.maska; /*IRQ request A*/
                        case 0x18: return ioc.maska; /*IRQ mask A*/
                        case 0x20: return ioc.statb; /*IRQ status B*/
                        case 0x24: return ioc.statb&ioc.maskb; /*IRQ request B*/
                        case 0x28: return ioc.maskb; /*IRQ mask B*/
                        case 0x30: return ioc.statf; /*FIQ status*/
                        case 0x38: return ioc.maskf; /*FIQ mask*/
                        case 0x40: return ioc.t1r&0xFF;
                        case 0x44: return ioc.t1r>>8;
                        case 0x50: return ioc.t2r&0xFF;
                        case 0x54: return ioc.t2r>>8;
                        case 0x60: return ioc.t3r&0xFF;
                        case 0x64: return ioc.t3r>>8;
                        case 0x70: return ioc.t4r&0xFF;
                        case 0x74: return ioc.t4r>>8;
                }
                rpclog("Bad IOC read %08X\n",addr);
                dumpregs();
                exit(-1);
                break;
                case 1: case 2:
                if (addr>=0x3012000) return readfdcdma(addr);
                return read82c711(addr);
                case 5: /*IOEB*/
                if (addr==0x3350050) return 5; /*IOEB present*/
        }
        return 0xFF;
}

void writeioc(unsigned long addr, unsigned char val)
{
        int bank=(addr>>16)&7;
        switch (bank)
        {
                case 0: /*Internal registers*/
                switch (addr&0x7C)
                {
                        case 0x00: cmosi2cchange(val&2,val&1); return; /*Control*/
                        case 0x04: ioc.statb&=~0x40; updateiocirqs(); iockey2=val; keydelay=1536; keyway|=1; return; /*Keyboard*/
                        case 0x14: ioc.stata&=~val; updateiocirqs(); return;
                        case 0x18: ioc.maska=val; updateiocirqs(); return;
                        case 0x28: ioc.maskb=val; updateiocirqs(); return;
                        case 0x38: ioc.maskf=val; updateiocirqs(); return;
                        case 0x40: ioc.t1l=(ioc.t1l&0xFF00)|val; return;
                        case 0x44: ioc.t1l=(ioc.t1l&0xFF)|(val<<8); return;
                        case 0x48: ioc.t1c=ioc.t1l; settimer1(); return;
                        case 0x4C: ioc.t1c-=16; ioc.t1r=ioc.t1c; return;
                        case 0x50: ioc.t2l=(ioc.t2l&0xFF00)|val; return;
                        case 0x54: ioc.t2l=(ioc.t2l&0xFF)|(val<<8); return;
                        case 0x58: ioc.t2c=ioc.t2l; settimer2(); return;
                        case 0x5C: ioc.t2c-=16; ioc.t2r=ioc.t2c; return;
                        case 0x60: ioc.t3l=(ioc.t3l&0xFF00)|val; return;
                        case 0x64: ioc.t3l=(ioc.t3l&0xFF)|(val<<8); return;
                        case 0x68: ioc.t3c=ioc.t3l; return;
                        case 0x6C: ioc.t3r=ioc.t3c; ioc.t3c--; return;
                        case 0x70: ioc.t4l=(ioc.t4l&0xFF00)|val; return;
                        case 0x74: ioc.t4l=(ioc.t4l&0xFF)|(val<<8); return;
                        case 0x78: ioc.t4c=ioc.t4l; return;
                        case 0x7C: ioc.t4r=ioc.t4c; ioc.t4c--; return;
                }
                return;
                printf("Bad IOC write %08X %02X\n",addr,val);
                dumpregs();
                exit(-1);
                case 1: case 2:
                if (addr>=0x3012000) writefdcdma(addr,val);
                else                 write82c711(addr,val);
                return;
        }
}

void keycallback()
{
        if (keyway&1)
        {
                writekeyboard(iockey2);
                ioc.statb|=0x40;
                updateiocirqs();
                keyway&=~1;
        }
}

void keycallback2()
{
        if (keyway&2)
        {
//                printf("Sent key callback %02X %02X\n",ioc.statb&0x80,tempkey);
                if (ioc.statb&0x80)
                {
                        keydelay2+=256;
                        return;
                }
                iockey=tempkey;
                ioc.statb|=0x80;
                updateiocirqs();
                keyway&=~2;
        }
}

void sendkey(unsigned char v)
{
        tempkey=v;
        keydelay2=512;
        keyway|=2;
//        printf("Sent key! %02X\n",v);
}


void iocfiq(unsigned char val)
{
        ioc.statf|=val;
        updateiocirqs();
//        printf("FIQ! %02X %02X %02X\n",val,ioc.statf,ioc.maskf);
//        output=1;
//        timetolive=1000;
}
void iocfiqc(unsigned char val)
{
        ioc.statf&=~val;
        updateiocirqs();
//        printf("FIQc %02X %02X %02X\n",val,ioc.statf,ioc.maskf);
}
