#include "mem.h"

struct
{
        unsigned long ctrl;
        unsigned long cache,update,disrupt;
} arm3cp;

void resetcp15()
{
        arm3cp.ctrl=0;
}

void writecp15(unsigned long addr, unsigned long val, unsigned long op)
{
        switch (addr)
        {
                case 1: /*Flush cache*/
                resetcodeblocks();
                readmemcache=readmembcache=0xFFFFFFFF;
                writememcache=writemembcache=0xFFFFFFFF;
                return;
                case 2: /*CTRL*/
                arm3cp.ctrl=val;
                printf("CTRL %08X\n",val);
                return;
                case 3: /*Cacheable areas*/
                arm3cp.cache=val;
                return;
                case 4: /*Updateable areas*/
                arm3cp.update=val;
                return;
                case 5: /*Disruptive areas*/
                arm3cp.disrupt=val;
                return;
        }
}

unsigned long readcp15(unsigned long addr)
{
        switch (addr)
        {
                case 0: /*ID*/
                return 0x41560300; /*VLSI ARM3*/
                case 2: /*CTRL*/
                return arm3cp.ctrl;
                case 3: /*Cacheable areas*/
                return arm3cp.cache;
                case 4: /*Updateable areas*/
                return arm3cp.update;
                case 5: /*Disruptive areas*/
                return arm3cp.disrupt;
        }
        return 0;
}
